package org.libvirt;

/**
 * Class for representing an unsigned long int scheduler parameter
 * 
 * @author stoty
 * 
 */
public final class SchedUlongParameter extends SchedParameter {
	
    /**
     * The parameter value
     */
    public long value;

    /**
     * Constructor default
     */
    public SchedUlongParameter() {
    }

    /**
     * Constructor with arguments
     * 
     * @param value long
     */
    public SchedUlongParameter( final long value ) {
        this.value = value;
    }

    /**
     * Return value type
     * 
     * @return int
     */
    public int getType() {
        return 4;
    }

    /**
     * Return value type as string
     * 
     * @return String
     */
    public String getTypeAsString() {
        return "VIR_DOMAIN_SCHED_FIELD_ULLONG";
    }

    /**
     * Return value as string
     * 
     * @return String
     */
    public String getValueAsString() {
        return Long.toString(value);
    }
    
}