package org.libvirt;

/**
 * Class for representing a long int scheduler parameter
 * 
 * @author stoty
 * 
 */
public final class SchedLongParameter extends SchedParameter {
	
    /**
     * The parameter value
     */
    public long value;

    /**
     * Constructor default
     */
    public SchedLongParameter() {
    }

    /**
     * Constructor with arguments
     * 
     * @param value long
     */
    public SchedLongParameter( final long value ) {
        this.value = value;
    }

    /**
     * Return value type
     * 
     * @return int
     */
    public int getType() {
        return 3;
    }

    /**
     * Return value type as string
     * 
     * @return String
     */
    public String getTypeAsString() {
        return "VIR_DOMAIN_SCHED_FIELD_LLONG";
    }

    /**
     * Return value as string
     * 
     * @return String
     */
    public String getValueAsString() {
        return Long.toString( value );
    }

}