package org.libvirt;

/**
 * Class for representing a double scheduler parameter
 * 
 * @author stoty
 * 
 */
public final class SchedDoubleParameter extends SchedParameter {
	
    /**
     * The parameter value
     */
    public double value;

    /**
     * Constructor default
     */
    public SchedDoubleParameter() {
    }

    /**
     * Constructor with arguments
     * 
     * @param value double
     */
    public SchedDoubleParameter( final double value ) {
        this.value = value;
    }

    /**
     * Return value type
     * 
     * @return int
     */
    public int getType() {
        return 5;
    }

    /**
     * Return value type as string
     * 
     * @return String
     */
    public String getTypeAsString() {
        return "VIR_DOMAIN_SCHED_FIELD_DOUBLE";
    }

    /**
     * Return value as string
     * 
     * @return String
     */
    public String getValueAsString() {
        return Double.toString( value );
    }
    
}