package org.libvirt;

import org.libvirt.jna.virVcpuInfo;

/**
 * Stats about a cpu.
 */
public final class VcpuInfo {
	
    public static enum VcpuState {
        VIR_VCPU_OFFLINE, VIR_VCPU_RUNNING, VIR_VCPU_BLOCKED
    }

    public int number;
    public VcpuState state;
    public long cpuTime;

    public int cpu;

    /**
     * Constructor default
     */
    public VcpuInfo() {
    }

    /**
     * Constructor with arguments
     * 
     * @param vVcpu virVcpuInfo
     */
    public VcpuInfo( final virVcpuInfo vVcpu ) {
        this.number = vVcpu.number;
        this.cpuTime = vVcpu.cpuTime;
        this.cpu = vVcpu.cpu;
        this.state = VcpuState.values()[ vVcpu.state ];
    }
    
}