package org.libvirt;

import org.libvirt.jna.virStorageVolInfo;

/**
 * Detailed information about a storage pool.
 */
public final class StorageVolInfo {

    public static enum VirStorageVolType {
        /**
         * Regular file based volumes
         */
        VIR_STORAGE_VOL_FILE,
        /**
         * Block based volumes
         */
        VIR_STORAGE_VOL_BLOCK
    }

    /**
     * The type of the Volume
     */
    public VirStorageVolType type;
    /**
     * Logical size bytes
     */
    public long capacity;

    /**
     * Current allocation bytes
     */
    public long allocation;

    /**
     * Constructor default
     */
    StorageVolInfo() {
    }
    
    /**
     * Constructor with arguments
     * 
     * @param volInfo virStorageVolInfo
     */
    StorageVolInfo( final virStorageVolInfo volInfo ) {
        this( volInfo.type, volInfo.capacity, volInfo.allocation );
    }
    
    /**
     * This is meant to be called from the JNI side, as a convenience
     * constructor
     * 
     * @param type int  The type, as defined by libvirt
     * @param capacity long
     * @param allocation long
     */
    StorageVolInfo( final int type, final long capacity, final long allocation ) {
        switch( type ) {
            case 0:
                this.type = VirStorageVolType.VIR_STORAGE_VOL_FILE;
                break;
            case 1:
                this.type = VirStorageVolType.VIR_STORAGE_VOL_BLOCK;
                break;
            default:
                assert( false );
        }
        this.capacity = capacity;
        this.allocation = allocation;
    }

    @Override
	public String toString() {
        return String.format( "type:%s%ncapacity:%d%nallocation:%d%n", type, capacity, allocation );
    }    	
    
}