package org.libvirt;

/**
 * Class for representing an unsigned int scheduler parameter
 * 
 * @author stoty
 * 
 */
public final class SchedUintParameter extends SchedParameter {
	
    /**
     * The parameter value
     */
    public int value;

    /**
     * Constructor default
     */
    public SchedUintParameter() {
    }

    /**
     * Constructor with arguments
     * 
     * @param value int
     */
    public SchedUintParameter( final int value ) {
        this.value = value;
    }

    /**
     * Return value type
     * 
     * @return int
     */
    public int getType() {
        return 2;
    }

    /**
     * Return value type as string
     * 
     * @return String
     */
    public String getTypeAsString() {
        return "VIR_DOMAIN_SCHED_FIELD_UINT";
    }

    /**
     * Return value as string
     * 
     * @return String
     */
    public String getValueAsString() {
        return Integer.toString( value );
    }
    
}