package org.libvirt;

/**
 * Parameter to hold an int.
 */
public final class SchedIntParameter extends SchedParameter {
	
    public int value;

    /**
     * Constructor default
     */
    public SchedIntParameter() {
    }

    /**
     * Constructor with arguments
     * 
     * @param value int
     */
    public SchedIntParameter( final int value ) {
        this.value = value;
    }

    /**
     * Return value type
     * 
     * @return int
     */
    public int getType() {
        return 1;
    }

    /**
     * Return value type as string
     * 
     * @return String
     */
    public String getTypeAsString() {
        return "VIR_DOMAIN_SCHED_FIELD_INT";
    }

    /**
     * Return value as string
     * 
     * @return String
     */
    public String getValueAsString() {
        return Integer.toString( value );
    }
    
}