package org.libvirt;

/**
 * Class for representing a boolean scheduler parameter
 * 
 * @author stoty
 * 
 */
public final class SchedBooleanParameter extends SchedParameter {
	
    /**
     * The parameter value
     */
    public boolean value;

    /**
     * Constrcutor default
     */
    public SchedBooleanParameter() {
    }

    /**
     * Constructor with arguments
     * 
     * @param value boolean
     */
    public SchedBooleanParameter( final boolean value ) {
        this.value = value;
    }

    /**
     * Constructor with arguments
     * 
     * @param value byte
     */
    public SchedBooleanParameter( final byte value ) {
        this.value = ( ( ( value ) != 0 ) ? true : false );
    }

    /**
     * Return value type
     * 
     * @return int
     */
    public int getType() {
        return 6;
    }

    /**
     * Return value type as string
     * 
     * @return String
     */
    public String getTypeAsString() {
        return "VIR_DOMAIN_SCHED_FIELD_BOOLEAN";
    }

    /**
     * Return value as string
     * 
     * @return String
     */
    public String getValueAsString() {
        return Boolean.toString( value );
    }
    
}