package org.libvirt;

/**
 * This exception is thrown by all classes and methods of libvirt when the
 * underlying libvirt library indicates an error
 * 
 * @author stoty
 * @see Error
 */
public final class LibvirtException extends Exception {

    private static final long serialVersionUID = 1L;

    Error virError;

    /**
     * Constructor
     */
    LibvirtException() {
    }
    
    /**
     * Constructor with arguments
     * 
     * @param virError Error
     */
    LibvirtException( final Error virError ) {
        super(virError.getMessage());
        this.virError = virError;
    }

    /**
     * Returns the underlying Error objects that contains details about
     * the cause of the exception
     * 
     * @return Error  The underlying Error object
     */
    public Error getError() {
        return virError;
    }

}