package org.libvirt;

import java.util.EnumSet;
import java.util.HashMap;

public enum CPUCompareResult {
	
    VIR_CPU_COMPARE_ERROR(-1), VIR_CPU_COMPARE_INCOMPATIBLE( 0 ), VIR_CPU_COMPARE_IDENTICAL( 1 ), VIR_CPU_COMPARE_SUPERSET( 2 );

    static final HashMap<Integer, CPUCompareResult> lookup = new HashMap<Integer, CPUCompareResult>();

    static {
        for( final CPUCompareResult s : EnumSet.allOf( CPUCompareResult.class ) ) {
            lookup.put( s.getReturnCode(), s );
        }
    }

    private final int returnCode;
    
    /**
     * Constructor
     * 
     * @param returnCode int
     */
    CPUCompareResult( final int returnCode ) {
        this.returnCode = returnCode;
    }

    /**
     * Get value
     * 
     * @param value int
     * 
     * @return CPUCompareResult
     */
    public static CPUCompareResult get( final int value ) {
        return lookup.get( value );
    }

    /**
     * Get return code
     *  
     * @return int
     */
    public int getReturnCode() {
        return returnCode;
    }

}